#ifndef _My_RT_
#define _My_RT_

#pragma once

#include "mesh\Vector.h"
#include <CGAL/Regular_triangulation_3.h>
#include <CGAL/Regular_triangulation_euclidean_traits_3.h>
#include <CGAL/Triangulation_vertex_base_with_info_3.h>
#include <CGAL/Exact_predicates_exact_constructions_kernel.h>

template < class Traits, class TDS>
class RT : public CGAL::Regular_triangulation_3<Traits, TDS>
{
public:
	typedef RT<Traits, TDS> Rt;

	typedef typename Traits::Bare_point       Point;
	typedef typename Traits::RT               Weight;
	typedef typename Traits::Weighted_point   Weighted_point;
	typedef typename Traits::Segment_3     Segment;

	typedef typename CGAL::Regular_triangulation_3<Traits>::Bare_point Bare_point;
	typedef typename CGAL::Regular_triangulation_3<Traits>::Object Object;
	

	typedef typename Rt::Finite_vertices_iterator FiniteVerticesIterator;
	typedef typename Rt::Edge Edge;
	typedef typename Rt::Cell_handle Cell_handle;
	typedef typename Rt::Facet Facet;
	typedef typename Rt::Vertex_handle Vertex_handle;
	typedef typename Rt::Cell_circulator Cell_circulator;
	typedef typename Rt::Facet_circulator Facet_circulator;


private:
	std::vector<Vertex_handle> m_vertices;

public:

	
	RT()
	{
		
	}

	~RT()
	{
		
	}

public:

	static DDG::Vector exact_dual(Point& p0,Point& p1, Point& p2, Point& p3, double w0,double w1,double w2,double w3)
	{
		// exact computation business
		typedef typename CGAL::Exact_predicates_exact_constructions_kernel EK2;
		typedef typename CGAL::Regular_triangulation_euclidean_traits_3<EK2> EK;
		typedef typename CGAL::Cartesian_converter<Traits, EK> IK_to_EK;
		typedef typename CGAL::Cartesian_converter<EK, Traits> EK_to_IK;

		IK_to_EK to_exact;
		EK_to_IK to_inexact;

		EK::Construct_weighted_circumcenter_3 exact_weighted_circumcenter =
			EK().construct_weighted_circumcenter_3_object();

		EK::Weighted_point ewp0(to_exact(p0), to_exact(w0));
		EK::Weighted_point ewp1(to_exact(p1), to_exact(w1));
		EK::Weighted_point ewp2(to_exact(p2), to_exact(w2));
		EK::Weighted_point ewp3(to_exact(p3), to_exact(w3));
		Bare_point wcc = to_inexact(exact_weighted_circumcenter(ewp0, ewp1, ewp2, ewp3));

		return DDG::Vector(wcc.x(), wcc.y(), wcc.z());
	}

	void clear_all()
	{
		m_vertices.clear();
		this->clear();
	}

	bool build(const std::vector< std::pair<Weighted_point, int> >& wpoints)
	{
		clear_all();
		this->insert(wpoints.begin(), wpoints.end());

		unsigned nb_hidden = wpoints.size() - this->number_of_vertices();
		/*if (nb_hidden > 0)
		std::cout << red << "hidden vertices! " << white << std::endl;*/

		m_vertices = std::vector<Vertex_handle>(wpoints.size());
		Finite_vertices_iterator vi = this->finite_vertices_begin();
		for (; vi != this->finite_vertices_end(); ++vi)
		{
			//	std::cout << "info: " << vi->info() << std::endl;
			m_vertices[vi->info()] = vi;
		}

		return true;
	}

	Vertex_handle get_vertex(int i) const
	{
		return m_vertices[i];
	}

	Vertex_handle get_source(const Edge& e) const
	{
		return e.first->vertex(e.second);
	}
	Vertex_handle get_target(const Edge& edge) const
	{
		return edge.first->vertex(edge.third);
	}


	bool is_cell_bounded(Vertex_handle vi) const
	{
		std::vector<Facet> f_vec;
		Rt::incident_facets(vi, std::back_inserter(f_vec));
		for (int i = 0; i < f_vec.size(); i++)
		{
			if (is_infinite(f_vec[i]))
				continue;
			CGAL::Object object = this->dual(f_vec[i]);
			Segment segment;
			if (CGAL::assign(segment, object))
				continue;
			else
				return false;
		}
		return true;
	}
};

#endif // _My_RT_



